definition module ioAdmin


//////-----------------------------------------------------------------------//
/////                                                                       ///
////   Definitions for the internal administration                         ////
///                                                                       /////
//-----------------------------------------------------------------------//////

import intrface
from StdString import String
from StdIOCommon import IOFunction

:: Perhaps a = OK !a | Nope

:: IOadmin *s = { io_quit            :: !Bool,
			 	  io_menuState       :: !Perhaps (MenuWinAdmin s),
/* RWS ---
				  io_windowState     :: ![(WindowAdmin s)], 
				  io_timers          :: ![TimerAdmin s],
				  io_dialogs         :: ![DialogAdmin s],
				  io_noticeresult    :: !Perhaps NoticeButtonId,
				  io_ddehandler      :: !String -> (s -> *((IOState s) -> (s,IOState s))),
--- RWS */
				  io_delayedmessages :: ![ CrossCallInfo ]
			    }


PackIOState   :: !(IOadmin s) !OS -> Toolbox 

UnpackIOState :: !(IOState s) -> (!IOadmin s, !OS)

UnpackIOStateWithCheck :: !(IOState s) -> (!IOadmin s, !OS)

EventsToOs :: !EVENTS -> OS

OsToEvents :: !OS -> EVENTS

ChangeOs :: !(OS -> OS) !(IOState s) -> (IOState s) 

EmptyIOadmin :: IOadmin s

//-----------------------------------------------------------------------

:: MenuKind  =  MenuBarK
			  | PullDownK
              | SubMenuK
              | ItemGroupK
              | RadioGroupK

:: MenuItemKind  =  RadioItemK
                  | CheckItemK
                  | ItemK

:: MenuAdmin *s = {  mkind     :: !MenuKind,
				     mid       :: !Int,
				     mtitle    :: !String,
				     melements :: ![MAdmin s],
				     menabled  :: !Bool,
				     mhandle   :: !HMENU,
					 mparent   :: !HMENU,
					 mpos      :: !Int
			       }

:: ItemAdmin *s = {  ikind     :: !MenuItemKind, 
				     iid       :: !Int,
					 ihandle   :: !HITEM,
				     ititle    :: !String,
// RWS ---		     ikey      :: !KeyShortcut,
				     ienabled  :: !Bool,
				     imarked   :: !Bool,
/* RWS ...
				     ifunction :: !MenuFunction s (IOState s),
*/
					 ifunction :: !IOFunction s,
/* ... RWS */
				 	 iparent   :: !HMENU,
					 ipos      :: !Int
			       }


:: MenuWinAdmin *s = {  mbwinhandle :: !HWND,
				 	    mbmenu      :: !MAdmin s
				      }

:: MAdmin *s =  Menu !(MenuAdmin s)
              | Item !(ItemAdmin s)  
			  | Separator

/* RWS ---
//------------------------------------------------------------------


:: WindowKind =  ScrollK
			   | FixedK


:: WindowAdmin *s = {
					   wkind       :: !WindowKind,
					   wid         :: !Int,
					   whandle     :: !HWND,
			           wtitle      :: !String,
					   wminwidth   :: !Int,
					   wminheight  :: !Int,
					   wupdatef    :: !UpdateFunction s,
				 	   wdomain     :: !PictureDomain,
                       wpicstate   :: !PictureState,
					   whscroll    :: !Int,
					   wvscroll    :: !Int,  
					   whthumb     :: !Int,
					   wvthumb     :: !Int,  
					   wgoaway     :: !WindowFunction s (IOState s),
					   wactivate   :: !WindowFunction s (IOState s),
					   wdeactivate :: !WindowFunction s (IOState s),
					   wkeyboardf  :: !KeyboardFunction s (IOState s),
					   wkeybable   :: !Bool,
					   wmousef     :: !MouseFunction s (IOState s),
					   wmouseable  :: !Bool,
					   wcursor     :: !CursorShape
                    }				
				      
//-----------------------------------------------------------

:: TimerAdmin *s = { tid       :: !Int,
                     thandle   :: !HITEM,
                     tinterval :: !Int,
					 tlasttime :: !Int,
                     tfunction :: !TimerFunction s (IOState s),
				     table     :: !Bool
			  	   }

//---------------------------------------------------------------------



:: DialogAdmin *s = { dId     :: !Int,
                      dHandle :: !HWND,
					  dKind   :: !DialogKind,
					  dItems  :: ![ControlAdmin s]
					}

:: DialogKind = ModalK | ModelessK

:: ControlAdmin *s = { cId      :: !Int,
                       cHandle  :: !HWND,
					   cKind    :: !ControlKind s,
					   cEnabled :: !Bool,
					   cItems   :: ![ CheckRadioAdmin s ]
				     }

:: ControlKind *s = ButtonK       !(ButtonFunction s (IOState s))
                  | IconButtonK   !PictureState !PictureDomain !IconLook !(ButtonFunction s (IOState s))
			      | StaticTextK
			      | DynamicTextK  
			      | EditTextK     !NrEditLines  !String
			      | PopupK        !DialogItemId	 
			      | RadioButtonsK !DialogItemId 
			      | CheckBoxesK   
			      | CustomK       !PictureState !PictureDomain !ControlState !ControlLook !ControlFeel !(DialogFunction s (IOState s))



:: CheckRadioAdmin *s = { caId      :: !DialogItemId,
                          caHandle  :: !HWND,
                          caKind    :: !CheckRadioKind,
						  caEnabled :: !Bool,
						  caFunct   :: !DialogFunction s (IOState s)
						}

:: CheckRadioKind = RadioK | CheckK !Bool


PackDialogInfo :: ![ !(!DialogItemId, !ItemInfo) ] -> DialogInfo
UnpackDialogInfo :: !DialogInfo -> [ ( !DialogItemId, !ItemInfo) ] 

PackDialogState :: !(DialogAdmin s) !OS -> DialogState s (IOState s)
UnpackDialogState :: !(DialogState s io) -> ( !DialogAdmin s, !OS)

  //------------------------------------------------//
 //      Helper functions                          //
//------------------------------------------------//

CursorShape2Code :: !CursorShape -> Int


SetBetween :: !Int !Int !Int -> Int


MakeMouseState :: !Int !Int !Int !Int -> MouseState

MakeKeyboardState :: !Int !Int !Int -> KeyboardState

toMods :: !Int -> Modifiers


SelectStateEqual :: !SelectState !SelectState -> Bool

MarkEqual  :: !MarkState !MarkState -> Bool

Enabled  :: !SelectState -> Bool

Marked  :: !MarkState -> Bool

:: Id   :== Int
:: Size :== (Int,Int)


:: Perhaps a  =  OK !a
			   | Nope

RectangleDimensions :: !Rectangle -> (Int,Int)

StateMap2 :: ( x s -> s) ![x] !s -> s

Select :: (x -> Bool) x ![x] -> (Bool, x)


// smap :: (a s -> (b,s)) [a] s  -> ([b],s)
smap f as s :== smap_ as s
where
	smap_ []       s  =  ([],s)
	smap_ [a:rest] s  =  ([b:restb],finals)
	where
		(b,s2)         = f a s 
		(restb,finals) = smap_ rest s2

Error :: !String !String !String -> .x

--- RWS */

